/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.api.VWScenarioStepSettings;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMRouteWeight;
import filenet.vw.api.VWException;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class VWSIMRoutingWeightTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 2;
    public static final int COL_NAME = 0;
    public static final int COL_WEIGHT = 1;
    private Vector m_rowData = null;
    private VWSIMPropertyData m_propertyData = null;
    private VWScenarioStepSettings m_stepSetting = null;

    public VWSIMRoutingWeightTableModel(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_rowData = new Vector();
    }

    public VWSIMRouteWeight getItemAt(int nRow) {
        if (this.m_rowData != null && nRow >= 0 && nRow < this.m_rowData.size()) {
            return (VWSIMRouteWeight)this.m_rowData.elementAt(nRow);
        }
        return null;
    }

    public void reinitialize(VWRouteDefinition[] routeDefs, VWScenarioStepSettings stepSetting) {
        try {
            this.m_rowData.removeAllElements();
            if (routeDefs != null) {
                this.m_stepSetting = stepSetting;
                if (routeDefs.length > 0) {
                    int individualWeight = 100 / routeDefs.length;
                    int roundUp = 100 % routeDefs.length;
                    for (int i = 0; i < routeDefs.length; ++i) {
                        String routeName = routeDefs[i].getName();
                        int routeID = routeDefs[i].getRouteId();
                        int weight = stepSetting.getRouteWeight(routeID);
                        VWSIMRouteWeight routeWeight = new VWSIMRouteWeight(routeName, routeID, weight);
                        this.m_rowData.addElement(routeWeight);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableDataChanged();
    }

    public int getTotalWeight() {
        int total = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            VWSIMRouteWeight routeWeight = this.getItemAt(i);
            total += routeWeight.getWeight();
        }
        return total;
    }

    public Class getColumnClass(int nColumn) {
        switch (nColumn) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumn) {
        switch (nColumn) {
            case 0: {
                return VWSIMResource.s_routeName;
            }
            case 1: {
                return VWSIMResource.s_weightPercentage;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowData.size();
    }

    public Object getValueAt(int nRow, int nColumn) {
        try {
            VWSIMRouteWeight routeWeight = this.getItemAt(nRow);
            switch (nColumn) {
                case 0: {
                    if (routeWeight == null) {
                        return new String();
                    }
                    return routeWeight.getName();
                }
                case 1: {
                    if (routeWeight == null) {
                        return new String("0");
                    }
                    return routeWeight.getWeight() + "";
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        switch (nColumn) {
            case 0: {
                return false;
            }
            case 1: {
                return this.getRowCount() > 1;
            }
        }
        return false;
    }

    public void setValueAt(Object value, int nRow, int nColumn) {
        switch (nColumn) {
            case 1: {
                this.onUpdateWeight(value, nRow);
            }
        }
    }

    private void onUpdateWeight(Object aValue, int nRow) {
        block6: {
            try {
                VWSIMRouteWeight routeWeight;
                if (aValue == null) break block6;
                Integer weightValue = null;
                try {
                    weightValue = new Integer((String)aValue);
                }
                catch (Exception ex) {
                    VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_invalidRouteWeight.toString((String)aValue), 1);
                    return;
                }
                if (weightValue == null || (routeWeight = this.getItemAt(nRow)) == null) break block6;
                int nOldWeight = routeWeight.getWeight();
                routeWeight.setWeight(weightValue);
                try {
                    this.m_stepSetting.setRouteWeight(routeWeight.getID(), routeWeight.getWeight());
                }
                catch (VWException ex) {
                    VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
                    this.m_stepSetting.setRouteWeight(routeWeight.getID(), nOldWeight);
                    routeWeight.setWeight(nOldWeight);
                }
                this.m_propertyData.setDirty();
                this.fireTableCellUpdated(nRow, 1);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }
}

